#! /usr/bin/perl -w

no warnings 'uninitialized';

################################################################################
# Dieses Script ist beim Linux Update Prozess das Verbindungsglied
# zwischen HPS und dem heruntergeladenen Installationspaket.
#
# Das Installationspaket wird in einem temporären Verzeichnis entpackt
# und das darin enthaltene Installationsscript mit einigen Parametern
# aufgerufen.
# Zum Schluß wird noch etwas aufgeräumt.
#
################################################################################
use strict;
use Getopt::Long;
use File::Path;
use File::Temp qw(tempdir);

################################################################################
#  Variablen
################################################################################
$0 =~ /(.*\/+)*(.+\.pl)/;
my $installPath = $1;
my $scriptName = $2;
my $currentDir = $ENV{PWD};

my $installer = "";
my $args = "--update";

my $currentUser = "";
my $installPathOwner = "";

my $tmpDir = tempdir(CLEANUP => 1);
my $sudoCommand = "";

################################################################################
#  Wartet auf eine Benutzereingabe und beendet dann das Script.
################################################################################
sub waitAndExit {
	print "\nBitte drücken Sie <ENTER> um fortzufahren.\n";
	my $input = <STDIN>;

	exit $_[0];
}

################################################################################
#  Liest die Kommandozeilen Parameter
################################################################################
sub getOptions {
	my $upgrade = 0;

	GetOptions("installer=s" => \$installer,
				"upgrade" => \$upgrade) || die "\033[1;31mEs fehlen Angaben.\033[0m";

	if ($installer eq "") {
		print "\033[1;31mEs fehlen Angaben zum Updatepaket\033[0m";
		waitAndExit 1;
	}

	if ($upgrade == 1) {
		$args = "--upgrade";
	}
}

################################################################################
#  Herausfinden, mit welchem Benutzer das Update gestartet wurde.
################################################################################
sub detectCurrentUser {
	my ($user, $passwd, $uid, $gid) = getpwuid $<;

	$currentUser = $user;
}

################################################################################
#  Herausfinden, mit welchem Benutzer das Update am besten statfindet.
################################################################################
sub detectInstallPathOwner {
	if ("$installPath" eq "") {
		print "\033[1;31mDas Installationsverzeichnis konnte nicht ermittelt werden.\033[0m";
		waitAndExit 1;
	}

	if (!opendir(INSTALL_DIR_HANDLE, "$installPath")) {
		print "\033[1;31mDas Installationsverzeichnis '$installPath' kann nicht geöffnet werden.\033[0m";
		waitAndExit 1;
	}

	my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks) = stat(INSTALL_DIR_HANDLE);

	$installPathOwner = getpwuid($uid);
}

################################################################################
#  Herausfinden, ob wir sudo benutzen müssen und ob wir eine grafische Variante
#  nehmen könne.
################################################################################
sub detectSudoCommand {
	if ($currentUser eq $installPathOwner) {
		return;
	}

	my @sudoProgramms = ("kdesudo", "kdesu", "gksudo", "gksu", "sudo");
	my $sudoMessage = "Für das Update sind Rootrechte erforderlich. Bitte geben Sie das Passwort ein.\n";

	foreach (@sudoProgramms) {
		if (system("which $_ > /dev/null 2>&1") == 0) {
			$sudoCommand = $_;
			if ($_ eq "sudo") {
				print $sudoMessage;
			} elsif ($_ eq "kdesudo") {
				$sudoCommand .= " -d --noignorebutton --comment \"$sudoMessage\" -- ";
			} elsif ($_ eq "kdesu") {
				$sudoCommand .= " -d --noignorebutton -- ";
			} elsif ($_ eq "gksudo") {
				$sudoCommand .= " --message \"$sudoMessage\" -- ";
			} elsif ($_ eq "gksu") {
				$sudoCommand .= " --message \"$sudoMessage\" ";
			}

			last;
		}
	}

	if ($sudoCommand eq "") {
		print "\033[1;31mEs wurde kein Programm gefunden um das Update als 'root' auszuführen. Installieren Sie dazu eines der Programme @sudoProgramms\n\033[0m";
		waitAndExit 1;
	}
}

################################################################################
#  Hier fängt das eigentliche Script an.
################################################################################
print "Starte Update Vorgang\n";

getOptions();
detectCurrentUser();
detectInstallPathOwner();

chdir($tmpDir);

# Entpacke Installationspacket
my $result = system("tar xvzf $installer > /dev/null 2>&1");

if ($result != 0) {
	print "\033[1;31mBeim Entpacken sind Fehler aufgetreten.\n\033[0m";
	waitAndExit 1;
}

# Starte Installationsscript
detectSudoCommand();
$result = system("$sudoCommand perl $tmpDir/install.pl --installdir=\"$installPath\" $args");

if ($result != 0) {
	print "\033[1;31mBeim Installieren sind Fehler aufgetreten.\n\033[0m";
}

# Aufräumen
chdir($currentDir);

waitAndExit $result;
