#!/bin/bash

msecondsSinceEpoch=`date +%s%N | cut -b1-13`

echo $msecondsSinceEpoch

for dir in `ls -d */ | cut -f1 -d'/'`
do
	echo $dir
	cd $dir

	for subdir in `ls -d */ | cut -f1 -d'/'`
	do
		echo $subdir
		cd $subdir

		for file in `ls *.svg`
		do
			echo $file

			cat $file >> "../$dir.json"
cat <<EOF >> "../$dir.json"

{
	lastChanged: $msecondsSinceEpoch,
	elementType: "template",
	visible: true,
	tags: {
		CATEGORY: [
			"category-invitation"
		]
	},
	designElementId: $dir,
	articles: [
		{
			id: 8850,
			otxtToken: "EC201S10"
		},
		{
			id: 8569,
			otxtToken: "EC101S10"
		}
	],
	productionId: "$subdir",
	expirationDate: null,
	score: 0,
	customScore: 0,
	publishedAt: $msecondsSinceEpoch
}
EOF
		done

		cd ..
	done

	cd ..
done
